@echo off

rem Rotationssicherung mit Drive Snapshot  Version 3.0
rem Autor: Andreas Weber
rem www.andysblog.de

rem Fenster-Titel festlegen

 title Datensicherung
 
rem Konfiguration

 rem Ziel festlegen
 
  rem Netzlaufwerk

  REM net use V: \\BACKUPSERVER\backup KENNWORT /user:BENUTZERNAME /persistent:no
  REM set Destination=V:
  
  rem Lokales Ziel
  
   set Destination=F:\Backup\%computername%

 rem Pfad fuer die Protokolle festlegen

  set LogDir=C:\Backup\Logs
     
 rem Festlegen, wie viele Wochen gesichert werden

  set NumberOfWeeksToKeep=4

 rem Tag der Vollsicherung festlegen

  set FullBackupDay=Monday

rem Woche auslesen und Leerzeichen entfernen

 set /p Week=< Week.txt
 set Week=%Week: =%

rem Wochentag auslesen

 Tools\weekday.exe > weekday.txt
 set /p Weekday=< weekday.txt
 
rem Datum und Uhrzeit fuer die E-Mail setzen

 set Datum=%date%
 set Uhrzeit=%time:~0,5%

rem Fehler-Variable setzen

 set error=false

rem Vollstaendige Datensicherung ausfuehren, sofern der Tag stimmt.

 if %Weekday%==%FullBackupDay% goto full

rem Ausfuehren der differentiellen Datensicherung

 del %LogDir%\Current.log /q

 snapshot.exe HD1:1 %Destination%\Diff-%Week%-%Weekday%-$disk.sna -h%Destination%\Full-%Week%-%FullBackupDay%-$disk.hsh -WT --novss -L350 --LogFile:%LogDir%\Current.log
 if not %errorlevel%==0 set error=true
 snapshot.exe C: %Destination%\Diff-%Week%-%Weekday%-$disk.sna -h%Destination%\Full-%Week%-%FullBackupDay%-$disk.hsh -RWT --AllWriters -L307200 --LogFile:%LogDir%\Current.log
 if not %errorlevel%==0 set error=true
 
 copy %LogDir%\Current.log %LogDir%\%Week%-%Weekday%.txt /y
 
 goto email

rem Ausfuehren der vollstaendigen Datensicherung
:full

 rem Wochenwechsel

  set /A Week=Week %% NumberOfWeeksToKeep + 1
  echo %Week% > week.txt

  del %LogDir%\Current.log /q
  
  snapshot.exe HD1:1 %Destination%\Full-%Week%-%Weekday%-$disk.sna -WT --novss -L350 --LogFile:%LogDir%\Current.log
  if not %errorlevel%==0 set error=true
  snapshot.exe C: %Destination%\Full-%Week%-%Weekday%-$disk.sna -RWT --AllWriters -L307200 --LogFile:%LogDir%\Current.log
  if not %errorlevel%==0 set error=true
  
   copy %LogDir%\Current.log %LogDir%\%Week%-%Weekday%.txt /y
   
rem E-Mail
:email

 echo. > e-mail.txt
 if %error%==false echo Die Datensicherung am %Datum% um %Uhrzeit% von Computer %computername% war erfolgreich. >> e-mail.txt
 if %error%==true echo Die Datensicherung am %Datum% um %Uhrzeit% von Computer %computername% war NICHT erfolgreich. >> e-mail.txt

 REM Tools\smtpsend.exe -fABSENDER -tEMPFAENGER -hMAILSERVER -sDatensicherung -ie-mail.txt -luBENUTZERNAME -lpKENNWORT
 REM Tools\smtpsend.exe -fABSENDER -tEMPFAENGER -hMAILSERVER -sBackup -i%LogDir%\%Week%-%Weekday%.txt -luBENUTZERNAME -lpKENNWORT

rem Netzlaufwerk trennen

 REM net use V: /d