@echo off

rem Fenster-Titel festlegen

 title Datensicherung
 
rem Konfiguration

 rem Ziel festlegen
 
  rem Netzlaufwerk

  REM net use V: \\BACKUPSERVER\backup KENNWORT /user:BENUTZERNAME /persistent:no
  REM set Destination=V:
  
  rem Lokales Ziel
  
   set Destination=E:\Backup\%computername%

 rem Pfad fuer die Protokolle festlegen

  set LogDir=C:\Backup\Logs
     
 rem Festlegen, wie viele Wochen gesichert werden

  set NumberOfWeeksToKeep=4

 rem Tag der Vollsicherung festlegen

  set FullBackupDay=Monday

rem Woche auslesen und Leerzeichen entfernen

 set /p Week=< Week.txt
 set Week=%Week: =%

rem Wochentag auslesen

 REM Tools\weekday.exe > weekday.txt
 REM set /p Weekday=< weekday.txt
 
 for /f %%g in ('wmic path win32_localtime get dayofweek^|findstr /v /r "^$"') do (set Weekday=%%g)

 if %Weekday%==0 set Weekday=Sunday
 if %Weekday%==1 set Weekday=Monday
 if %Weekday%==2 set Weekday=Tuesday
 if %Weekday%==3 set Weekday=Wednesday
 if %Weekday%==4 set Weekday=Thursday
 if %Weekday%==5 set Weekday=Friday
 if %Weekday%==6 set Weekday=Saturday
 
 REM set Weekday=Monday
 
rem Datum und Uhrzeit fuer die E-Mail setzen

 set Datum=%date%
 set Uhrzeit=%time:~0,5%

rem Fehler-Variable setzen

 set error=false

rem Vollstaendige Datensicherung ausfuehren, sofern der Tag stimmt.

 if %Weekday%==%FullBackupDay% goto full

rem Ausfuehren der differentiellen Datensicherung

 del %LogDir%\Current.log /q

 snapshot.exe HD1:1 %Destination%\Diff-%Week%-%Weekday%-$disk.sna -h%Destination%\Full-%Week%-%FullBackupDay%-$disk.hsh -WT --novss -L0 --LogFile:%LogDir%\Current.log --CreateDir --FullIfHashIsMissing
 if not %errorlevel%==0 set error=true
 snapshot.exe C: %Destination%\Diff-%Week%-%Weekday%-$disk.sna -h%Destination%\Full-%Week%-%FullBackupDay%-$disk.hsh -RWT --AllWriters -L0 --LogFile:%LogDir%\Current.log --FullIfHashIsMissing
 if not %errorlevel%==0 set error=true
 
 copy %LogDir%\Current.log %LogDir%\%Week%-%Weekday%.txt /y
 
 goto eventlog

rem Ausfuehren der vollstaendigen Datensicherung
:full

 rem Wochenwechsel

  set /A Week=Week %% NumberOfWeeksToKeep + 1
  echo %Week% > week.txt

 rem Vorige "Current.log" entfernen
 
  del %LogDir%\Current.log /q
  
 rem Alten Sicherungssatz entfernen
 
  del %destination%\*-%Week%-*.sna /q  
  
 snapshot.exe HD1:1 %Destination%\Full-%Week%-%Weekday%-$disk.sna -WT --novss -L0 --LogFile:%LogDir%\Current.log --CreateDir
 if not %errorlevel%==0 set error=true
 snapshot.exe C: %Destination%\Full-%Week%-%Weekday%-$disk.sna -RWT --AllWriters -L0 --LogFile:%LogDir%\Current.log
 if not %errorlevel%==0 set error=true
  
 copy %LogDir%\Current.log %LogDir%\%Week%-%Weekday%.txt /y

rem Ereignisprotokoll-Eintrag
:eventlog

 setlocal enableextensions enabledelayedexpansion
 
 set eventtext=
 
 REM for /f "delims=" %%l in (%LogDir%\Current.log) do set eventtext=!eventtext!%%l
 
 for /f "delims=" %%l in (%LogDir%\Current.log) do set eventtext=!eventtext!%%%l___
 
 set eventtext_cut=!eventtext:~0,5000!
 
 if %error%==false (
  eventcreate /id 100 /l application /t information /so "DriveSnapshotAgent" /d "%eventtext_cut%"
  ) else (
  eventcreate /id 100 /l application /t error /so "DriveSnapshotAgent" /d "%eventtext_cut%"
  )
   
 setlocal disableextensions disabledelayedexpansion
 endlocal
    
rem E-Mail
:email

 echo. > e-mail.txt
 if %error%==false echo Die Datensicherung am %Datum% um %Uhrzeit% von Computer %computername% war erfolgreich. >> e-mail.txt
 if %error%==true echo Die Datensicherung am %Datum% um %Uhrzeit% von Computer %computername% war NICHT erfolgreich. >> e-mail.txt

 REM Tools\smtpsend.exe -fABSENDER -tEMPFAENGER -hMAILSERVER -sDatensicherung -ie-mail.txt -luBENUTZERNAME -lpKENNWORT
 REM Tools\smtpsend.exe -fABSENDER -tEMPFAENGER -hMAILSERVER -sBackup -i%LogDir%\%Week%-%Weekday%.txt -luBENUTZERNAME -lpKENNWORT

rem Netzlaufwerk trennen

 REM net use V: /d