@echo off

title Wiederherstellungslaufwerk anpassen

rem Konfiguration

 rem WorkingDir
 
  set WorkingDir=C:\Temp
  cd %WorkingDir%

 rem Pfad zur "boot.wim"

  set Winre-Path=F:\sources

rem Ordner anlegen

 md Mount

rem Drive Snapshot herunterladen

 if exist "%systemroot%\SysWOW64" ("Rescue\Drive Snapshot\ds-update_amd64.exe") else ("Rescue\Drive Snapshot\ds-update_x86.exe")
 if exist snapshot64.exe move /y snapshot64.exe "Rescue\Drive Snapshot\snapshot64.exe"
 if exist snapshot.exe move /y snapshot.exe "Rescue\Drive Snapshot\snapshot.exe"

rem Attribute von "boot.wim" entfernen, damit die Datei anschliessend bearbeitet werden kann

 attrib -s -h %Winre-Path%\boot.wim

rem Sicherungskopie der "boot.wim" anlegen

 copy %Winre-Path%\boot.wim %WorkingDir%\boot.wim.org

rem "boot.wim" verschieben

 move %Winre-Path%\boot.wim %WorkingDir%

rem "boot.wim" einhaengen

 dism /mount-image /imagefile:boot.wim /index:1 /mountdir:Mount

rem "boot.wim" bearbeiten

 rem "winpeshl.ini" aktualisieren (ersetzen)
 rem Bemerkung: Direktes Ueberschreiben ist nicht mglich ("Zugriff verweigert/Access denied"), daher umbenennen und kopieren.

  ren Mount\Windows\System32\winpeshl.ini winpeshl.ini.bak
  copy Windows\System32\winpeshl.ini Mount\Windows\System32\winpeshl.ini

 rem Ordner hinzufuegen

  xcopy Rescue Mount\Rescue /e /i /y

rem "boot.wim" aushaengen

 dism /unmount-image /mountdir:Mount /commit

rem "boot.wim" (zurueck)verschieben

 move /y %WorkingDir%\boot.wim %Winre-Path%

rem Clean-up

 rem Original-Attribute der "boot.wim" wiederherstellen

  attrib +h +s %Winre-Path%\boot.wim

 rem Verzeichnisse entfernen

  rmdir Mount /s /q
